VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cShapeStar"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private WithEvents ROuter As cControlPoint
Attribute ROuter.VB_VarHelpID = -1
Private WithEvents RInner As cControlPoint
Attribute RInner.VB_VarHelpID = -1
Private WithEvents CenterDrag As cControlPoint
Attribute CenterDrag.VB_VarHelpID = -1

Public Sub Init(Controlpoints As cControlPoints, ByVal X As Double, ByVal Y As Double, ByVal RadiusOuter As Double, ByVal RadiusInner As Double)
  Set ROuter = Controlpoints.Add("ROuter" & ObjPtr(Me), X + RadiusOuter, Y, vbGreen, 6)
  Set RInner = Controlpoints.Add("RInner" & ObjPtr(Me), X + RadiusInner, Y, vbGreen, 6)
  Set CenterDrag = Controlpoints.Add("CenterDrag" & ObjPtr(Me), X, Y, vbMagenta, 9)
End Sub

Public Sub Draw(CC As cCairoContext)
  CC.Save
    'as always, we define the path first... (in this case a "5-point-star" is created)
    CC.DrawRegularPolygon CenterDrag.X, CenterDrag.Y, RadiusOuter, 5, splSmall, RadiusInner
    
    CC.SetSourceColor vbCyan, 0.5 '<- note the Alpha-Opacity-Value-Param (normally at default 1 = Full Opacity)
    CC.Fill True '<- note the Optional "True"-param here, meaning we do *not* want to close the path yet...
    
    '...since we plan to draw a Border this time too (with a different Stroke-Color)
    CC.SetSourceColor vbBlue, 0.5
    CC.Stroke '*now* the Path gets closed (no Optional DontClosePath-Param set) - and we ensure thereby a combined Fill+Stroke
  CC.Restore
End Sub

Public Property Get RadiusOuter() As Double
  RadiusOuter = ROuter.X - CenterDrag.X
End Property
Public Property Get RadiusInner() As Double
  RadiusInner = RInner.X - CenterDrag.X
End Property


'Control-Point Movement-Events are received below, and we will act accordingly with the necessary adaptions

Private Sub Router_PositionChanging(NewX As Double, NewY As Double)
  NewY = CenterDrag.Y
  
  If NewX - CenterDrag.X < 20 Then NewX = CenterDrag.X + 20 'we restrict the outer Radius to min 20 pixels
  If NewX - RInner.X < 10 Then NewX = RInner.X + 10 'we restrict the distance between Inner and outer Radius to 10 pixels
End Sub
Private Sub Rinner_PositionChanging(NewX As Double, NewY As Double)
  NewY = CenterDrag.Y
  
  If NewX - CenterDrag.X < 10 Then NewX = CenterDrag.X + 10 'we restrict the inner Radius to min 10 pixels
  If ROuter.X - NewX < 10 Then NewX = ROuter.X - 10 'we restrict the distance between Inner and outer Radius to 10 pixels
End Sub
Private Sub CenterDrag_PositionChanging(NewX As Double, NewY As Double)
Dim RO#, RI#
  RO = RadiusOuter: RI = RadiusInner 'we need to buffer the current Radie beforehand, to not mess-up the coord-adaptions below, since both are dynamically calculated in Properties
  
  ROuter.X = NewX + RO
  ROuter.Y = NewY
  
  RInner.X = NewX + RI
  RInner.Y = NewY
End Sub


